﻿<%@ Page Title="" Language="vb" AutoEventWireup="false" MasterPageFile="~/private/Private.Master" CodeBehind="fichazonas.aspx.vb" Inherits="Web.fichazonas" %>

<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">

    <asp:UpdatePanel runat="server" ID="UpdatePanelZonas" UpdateMode="Conditional">
        <ContentTemplate>

            <div class="block private">

                <div class="add-panel">
                    <div class="container">
                        <h2><%= Translator.Translate("ADMIN_ZONES")%></h2>
                    </div>
                </div>
                <div class="content ajax-tabs">

                    <div class="reg-form" runat="server" id="DivCamps">
                        <fieldset>
                            <div class="row private">
                                <asp:Label ID="lblIdZonaPadre" runat="server" CssClass="label" Width="80px"></asp:Label>
                                <asp:DropDownList ID="IdZonaPadre" runat="server" CssClass="input"></asp:DropDownList>
                            </div>
                            <div class="row private">
                                <asp:Label ID="lblTitulo" runat="server" CssClass="label"></asp:Label>
                                <asp:TextBox ID="Titulo" runat="server" CssClass="input" Text=""></asp:TextBox>
                            </div>

                            <br />

                            <!-- VINCULACIÓN DE SERVIDORES A ZONA -->
                            <div class="DockZone" runat="server" id="divVinculacionServidores" visible="false">
                                <div id="DockConfOrigen" class="Dock Dockvincular active">
                                    <!-- Cabecera -->
                                    <div class="add-panel">
                                        <div class="subpanel">
                                            <span><%= Translator.Translate("ZONES_CONFIG_SERVERS")%></span>
                                        </div>
                                        <div class="actions origen">
                                            <a id="opsetting" class="settings black" style="cursor: pointer;" runat="server" onclick="javascript:openMenuAccions('.origen .menuaccions ul.actionsmenu.level1',event);">Settings</a>
                                            <asp:Menu ID="menuServidores" SkinID="MenuAccions" runat="server" ItemWrap="True" Visible="true" OnMenuItemClick="menuServidores_MenuItemClick">
                                            </asp:Menu>
                                        </div>
                                    </div>
                                    <!-- Zona de contenido -->
                                    <div class="DockContent">
                                        <!-- Panel con gridview de servidores-->
                                        <asp:Panel ID="panelServidores" runat="server" CssClass="jcf-scrollable" Style="max-height: 260px; overflow: auto;">
                                            <asp:Repeater ID="repeater_servidores" runat="server" OnItemCommand="repeater_servidores_ItemCommand" OnItemDataBound="repeater_servidores_ItemDataBound">
                                                <HeaderTemplate>
                                                    <ul class="estaciones-destino">
                                                </HeaderTemplate>
                                                <ItemTemplate>
                                                    <li style="height: 40px !important;">
                                                        <div class="station">
                                                            <asp:LinkButton ID="lnkEstacion" runat="server" CssClass="procesos-nombre" Enabled="false" CommandArgument='<%# Eval("CodigoServidor")%>'><%# Eval("NombreServidor")%></asp:LinkButton>
                                                            <asp:LinkButton ID="LnkDelete" CommandName="Delete" CommandArgument='<%# Eval("CodigoServidor")%>' CssClass="remove" ToolTip='<%# Translator.Translate("ADMIN_ICON_DEL") %>' runat="server">Delete</asp:LinkButton>
                                                        </div>
                                                    </li>
                                                    <asp:HiddenField ID="hdnIndexServidor" runat="server" Value='<%# Eval("IndexServidor")%>' />
                                                </ItemTemplate>
                                                <FooterTemplate>
                                                    </ul>
                                                </FooterTemplate>
                                            </asp:Repeater>
                                        </asp:Panel>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <asp:Button ID="btnGuardar" runat="server" CssClass="btn" />
                                <asp:Button ID="btnEsborrar" runat="server" CssClass="btn" Visible="false" />
                                <asp:Button ID="btnCancelar" runat="server" CssClass="btn" Style="float: right;" />
                            </div>

                        </fieldset>

                        <!-- controles ocultos-->
                        <asp:HiddenField ID="IdZona" runat="server" />
                        <asp:HiddenField ID="RutaCompleta" runat="server" />
                        <asp:HiddenField ID="TieneServidores" runat="server" Value="0" />
                        <asp:HiddenField ID="IdCliente" runat="server" />
                        <asp:HiddenField ID="Orden" runat="server" Value="#null#" />
                        <asp:HiddenField ID="PK_IDZONA_AUX" runat="server" />

                    </div>
                </div>
            </div>

            <!--Panel formulario vinculación servidores -->
            <asp:Panel ID="PanelVincularServidores" runat="server" Style="display: none;" CssClass="error-message">
                <div class="holder">
                    <asp:Literal ID="Literal1" runat="server"></asp:Literal>
                    <asp:DropDownList ID="ddlServidores" runat="server" Width="200px" CssClass="combo">
                    </asp:DropDownList>
                    <br />
                    <br />
                    <asp:LinkButton ID="btnVincularServidor" runat="server" class="btn"><%= Translator.Translate("ZONES_CONFIG_SERVERS_OK")%></asp:LinkButton>
                    <asp:LinkButton ID="btnCancelar_VincularServidor" runat="server" class="btn"><%= Translator.Translate("ZONES_CONFIG_SERVERS_EXIT")%></asp:LinkButton>
                </div>
            </asp:Panel>

            <ajaxToolkit:ModalPopupExtender ID="MPE_PanelVincularServidores" runat="server" TargetControlID="hdnPanelVincularServidores" PopupControlID="PanelVincularServidores" BackgroundCssClass="" CancelControlID="btnCancelar_VincularServidor" DropShadow="false" PopupDragHandleControlID="" />
            <asp:HiddenField ID="hdnPanelVincularServidores" runat="server" />


            <!--Panel formulario Crear zona -->
            <asp:Panel ID="PanelCrearZona" runat="server" Style="display: none;" CssClass="error-message">
                <div class="holder">
                    <asp:Literal ID="Literal2" runat="server"></asp:Literal>
                    <br />
                    <asp:LinkButton ID="btnCrearZonaYTraspasar" runat="server" class="btn"><%= Translator.Translate("ZONES_CREATE_AND_SWITCH")%></asp:LinkButton>
                    <asp:LinkButton ID="btnCrearZona" runat="server" class="btn"><%= Translator.Translate("ZONES_CREATE_ONLY")%></asp:LinkButton>
                    <asp:HiddenField ID="hdnCancelarCrearZona" runat="server" />
                </div>
            </asp:Panel>

            <ajaxToolkit:ModalPopupExtender ID="MPE_CrearZona" runat="server" TargetControlID="hdnPanelCrearZona" PopupControlID="PanelCrearZona" BackgroundCssClass="" CancelControlID="hdnCancelarCrearZona" DropShadow="false" PopupDragHandleControlID="" />
            <asp:HiddenField ID="hdnPanelCrearZona" runat="server" />


            <!--Panel de errores del formulario de registro -->
            <asp:Panel ID="PanelErrores" runat="server" Style="display: none" CssClass="error-message">
                <div class="holder">
                    <asp:Literal ID="infoerrores" runat="server"></asp:Literal>
                    <asp:Button ID="btnAceptar_Esborrar" runat="server" Text="Borrar" Visible="false" />
                    <a id="btnCancelar_PanelErrores" href="#" runat="server" class="btn"><%= Translator.Translate("ADMIN_BTN_CLOSE")%></a>
                </div>
            </asp:Panel>

            <!-- controles ajax-->
            <ajaxToolkit:ModalPopupExtender ID="MPE_PanelErrores" runat="server" TargetControlID="hdnPanelErrores" PopupControlID="PanelErrores" BackgroundCssClass="" CancelControlID="btnCancelar_PanelErrores" DropShadow="false" PopupDragHandleControlID="" />

            <!-- controles ocultos-->
            <asp:HiddenField ID="hdnPanelErrores" runat="server" />

        </ContentTemplate>
        <Triggers>
            <asp:AsyncPostBackTrigger ControlID="btnGuardar" EventName="Click" />
            <asp:AsyncPostBackTrigger ControlID="btnCancelar" EventName="Click" />
        </Triggers>
    </asp:UpdatePanel>
    <ajaxToolkit:UpdatePanelAnimationExtender ID="UpdatePanelAnimationExtenderZonas" TargetControlID="UpdatePanelZonas" BehaviorID="animation" runat="server">
        <Animations>    
            <OnUpdated>
                <Sequence>
                    <FadeIn AnimationTarget="PanelErrores" Duration="0.15" minimumOpacity=".3"  />
                    <EnableAction AnimationTarget="btnCancelar_PanelErrores" Enabled="true" />
                    <ScriptAction Script="initRefreshFunctions();" />
                </Sequence>
            </OnUpdated>
        </Animations>
    </ajaxToolkit:UpdatePanelAnimationExtender>

</asp:Content>
